

***Creation input files for Pareto interpolation for wealth series ***

global projdir "W:\brtrd\Projet wealth_income\Imputation_gperc\Wealth"
*global projdir "C:\Users\G839276\Dropbox\WIDFrance\Papers\GGP2016Wealth\GGP2016WealthAppendixB\DataFiles\Exportation\Results"

cd "$projdir"


clear
import excel "$projdir\Pareto interpolations\averagewealth_year.xlsx", sheet("Feuil1") firstrow clear

tempfile temp1
save `temp1',replace
use "$projdir\dperc\dperc_w", clear
keep if sex==0
keep year dperc share_dperc
merge m:1 year using `temp1'
erase `temp1'
keep if _merge==3
drop _merge
g pop_share_above=1-dperc/100
replace pop_share=0.005 if dperc==995
replace pop_share=0.001 if dperc==999
g w_dperc = share*wmean
sort year dperc
bys year : gen double cumul = sum(w_dperc)
bys year: g order = _n
xtset year order
g double  mw_above_dperc = L.wmean-L.cumul
replace mw_above_dperc=wmean if dperc==0
g w_above_dperc= mw_above_dperc/pop_share
br
preserve
keep year wmean
bys year: keep if _n==1
save wmean_byyear,replace
restore

tempfile temp1
keep year dperc w_above wmean
save `temp1',replace

use "$projdir\gperc\gperc", replace
br
keep if sex==0 & inlist(gperc,0,10,20,30,40,50,60,70,80,90,95,990,9990,99990)
replace gperc=99 if gperc==990
replace gperc=999 if gperc==9990
replace gperc=9999 if gperc==99990
keep year gperc thr b
rename gperc dperc
rename b bgperc
merge 1:m year dperc using `temp1'
sort year dperc
br
keep if !(_merge==1)
drop _merge
replace thr=0 if missing(thr) & dperc==0
g b=w_above/thr
g p = dperc/100
replace p=0.999 if dperc==999
drop if dperc==995
*drop w_abo
drop b
rename bgperc b
reshape wide p thr b wmean w_abo, i(dperc) j(year)
save temp,replace


**** Interpolation of b
use temp,replace
br
capture program drop interpolation
program interpolation
args year1 year2
capture drop slope* a_*
g slope_b=(b`year2'-b`year1')/(`year2'-`year1')
g  a_b = (b`year1'-`year1'*slope_b)

local year_min=`year1'+1
local year_max=`year2'-1

forvalue year = `year_min'/`year_max'{
replace b`year'=a_b+slope_b*`year'
replace thr`year'=w_above_dperc`year'/b`year' if !missing(b`year')
*p`year' = dperc/100 
replace p`year'=0.999 if dperc==999
}
end

interpolation 1970 1975
interpolation 1975 1979
interpolation 1979 1984
interpolation 1984 1988
interpolation 1988 1990

drop a_* slope*
br
*order p1971 thr1971 zthr1971 w_above_dperc1971 zw1971 b1971 zb1971 zzb1971

keep dperc p* thr* b* wmean*

reshape long p thr b wmean, i(dperc) j(year)
sort year dperc
order dperc year wmean p thr b
rename wmean average

drop if year > 1989
drop if inlist(year, 1970,1975,1979,1984,1988)
replace b=. if b==0
drop dperc


capture program drop export_results
program export_results
args year
preserve
keep if year==`year'

export excel using "$projdir\Pareto interpolations\for_interpolation_byyear.xlsx", sheet("`year'") firstrow(variables) sheetmodify
restore
end

tab year

forvalue i=1971/1974{
export_results `i'
}
forvalue i=1976/1978{
export_results `i'
}
forvalue i=1980/1983{
export_results `i'
}
forvalue i=1985/1987{
export_results `i'
}
export_results 1989


/** Adding 2013 and 2014 **/
clear
import excel "$projdir\Pareto interpolations\averagewealth_year.xlsx", sheet("Feuil1") firstrow clear
tempfile temp1
save `temp1',replace
use "$projdir\dperc\dperc_w", clear
keep if sex==0
keep year dperc share_dperc
merge m:1 year using `temp1'
erase `temp1'
keep if _merge==3
drop _merge
g pop_share_above=1-dperc/100
replace pop_share=0.005 if dperc==995
replace pop_share=0.001 if dperc==999
g w_dperc = share*wmean
sort year dperc
bys year : gen double cumul = sum(w_dperc)
bys year: g order = _n
xtset year order
g double  mw_above_dperc = L.wmean-L.cumul
replace mw_above_dperc=wmean if dperc==0
g w_above_dperc= mw_above_dperc/pop_share
br
preserve
keep year wmean
bys year: keep if _n==1
save wmean_byyear,replace
restore

tempfile temp1
keep year dperc w_above wmean
save `temp1',replace

use "$projdir\gperc\gperc", replace
br
keep if sex==0 & inlist(gperc,0,10,20,30,40,50,60,70,80,90,95,990,9990,99990)
replace gperc=99 if gperc==990
replace gperc=999 if gperc==9990
replace gperc=9999 if gperc==99990
keep year gperc thr b
rename gperc dperc
rename b bgperc
merge 1:m year dperc using `temp1'
sort year dperc
br
keep if !(_merge==1)
drop _merge
replace thr=0 if missing(thr) & dperc==0
g b=w_above/thr
g p = dperc/100
replace p=0.999 if dperc==999
drop if dperc==995
*drop w_abo
keep if inlist(year,2012,2013,2014)
drop b
rename bgperc b

reshape wide p thr b  w_abo wmean, i(dperc) j(year)
/* b for 2013 and 2014 are set to 2012 values */
replace b2013=b2012
replace b2014=b2012
/* thresholds consistent with b and w above */
replace thr2013=w_above_dperc2013/b2013  
replace thr2014=w_above_dperc2014/b2014  
replace thr2013=0 if missing(thr2013) 
replace thr2014=0 if missing(thr2014)
br
keep dperc p* thr* b* wmean*
reshape long p thr b wmean, i(dperc) j(year)
drop dperc 
sort year p
drop if year==2012
order  year wmean p thr b
rename wmean average
replace b=. if b==0

forvalue i=2013/2014{
export_results `i'
}
erase "$projdir\temp.dta"



***** Average by year *******
* From WealthAppendixB, TB1

